//
// v.h - video support interface for screen to video out
//

// Initialize video subsystem
void v_init(void);
void v_done(void);

// Get list of video jacks
int v_make_jacklist(void *pjlist, int *pjcount);
int v_unmake_jacklist(void *pjlist, int jcount);

// Create a buffer header for a buffer
int v_make_header(void *inbuf, void **outheader, int w, int h,
    int rowbytes, int size);
int v_unmake_header(void *outheader);

// Start, stop, clean up the video transfer
int v_start(int jack, int width, int height);
int v_stop(void);
int v_reset(void);

// Video I/O thread entrypoint
DWORD WINAPI v_thread (LPVOID args);

// Arguments passed to video I/O thread
typedef struct threadargs_s {
    int killthread;		// 0 owned by main, 1 owned by thread
    void *(*nextbuf)(void);
} threadargs_t;

